 ; Ŀ
 ;   Duck - find and kill duplicate and superimposed text strings.         
 ;   Copyright 1995, 2003 by Rocket Software Ltd.                          
 ;   Rocket: programs a Cray would stop and think about.                   
 ; 

 ; Ŀ
 ;   Duplo - find enames in a list which have the same insertion point.    
 ;   Arguments: Lisa, a list of entity names.                              
 ;              Fuzz, a position inaccuracy allowance.                     
 ;   Returns a list of lists of enames with duplicate insertions.          
 ;   Caution: crashes if Lisa is nil.                                      
 ; 
 (DEFUN DUPLO (lisa fuzz / num enam poslis sub curpos cenam gnulst fuzzht
                                                      subnum sub2 check malist)
 ; Ŀ
 ;   Make a list of lists: ((position ename) ...).                         
 ; 
  (setq num 0)
  (while (setq enam (nth num lisa))
         (setq poslis (cons (cons (cdr (assoc 10 (entget enam))) enam) poslis))
         (setq num (1+ num)))
 ; Ŀ
 ;   Check each sublist for points which match the one in the first list.  
 ; 
  (while (setq sub (car poslis))       ; current (position enam) list
         (setq curpos (car sub))       ; position
         (setq cenam (cdr sub))        ; enam
         (setq gnulst (list cenam))    ; (enam) - stub list for pos matches
         (setq fuzzht (* fuzz (cdr (assoc 40 (entget cenam)))))
         (setq poslis (cdr poslis))
         (setq subnum 0)
         (setq sub2 ())
         (while (and (> (length poslis) subnum)
                     (setq check (nth subnum poslis)))
                (if (equal (car check) curpos fuzzht)
                    (setq gnulst (cons (cdr check) gnulst))
                    (setq sub2 (append sub2 (list check))))
                (setq subnum (1+ subnum)))
         (setq malist (cons gnulst malist))
         (setq poslis sub2))
 malist)
 ; Ŀ
 ;   Duplo end.                                                            
 ; 

 ; Ŀ
 ;   Ccr - grdraw a set of radial lines.                                   
 ;   Reps = lines in 360, divs = explosions/screen height, pa = centre.    
 ;   Calls nothing, returns nothing, but has a good attitude.              
 ; 
 (DEFUN CCR (pa reps divs / colo rad rad2 angg incr)
  (setq colo -1)
  (setq rad (/ (getvar "viewsize") divs))
  (setq rad2 (/ rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (grdraw (polar pa angg rad2) (polar pa angg rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Ccr end.                                                              
 ; 

 ; Ŀ
 ;   Crex - grdraw a temporary and gratuitous explosion.                   
 ;   Arguments: Pa, the centre point.                                      
 ;   Calls Ccr, Returns nothing.                                           
 ; 
 (DEFUN CREX (pa)
  (ccr pa 4 8)
  (ccr pa 27 12) (ccr pa 21 12)
  (ccr pa 45 10) (ccr pa 45 10)
  (ccr pa 45 19)
  (ccr pa 27 12) (ccr pa 21 12)
  (ccr pa 45 8)  (ccr pa 45 8)
  (ccr pa 45 19)
  (ccr pa 4 8)
  (ccr pa 45 6)  (ccr pa 45 6)
  (ccr pa 95 16) (ccr pa 95 16)
  (ccr pa 65 4)  (ccr pa 65 4)
  (ccr pa 25 3)  (ccr pa 25 3)
  (ccr pa 35 9)  (ccr pa 35 9)
 (princ))
 ; Ŀ
 ;   Crex end.                                                             
 ; 

 ; Ŀ
 ;   Dupe - find duplicate text strings.                                   
 ;   Arguments: Ss - an ss of text entities.                               
 ;   Returns a list of lists of enames of text with duplicate strings.     
 ; 
 (DEFUN DUPE (ss / num enam strlis newsub tmplst enamtx dups)
 ; Ŀ
 ;   Make a list of lists: each text string and ename.                     
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq strlis (append strlis (list (list 
                                        (cdr (assoc 1 (entget enam))) enam))))
         (setq num (1+ num)))
 ; Ŀ
 ;   Make the list Dups, which will consist of a sublist - for each        
 ;   duplicate string - of all enames containing that string.              
 ; 
  (while (and strlis (setq newsub (car strlis))) ; first string/ename sublist
 ; Ŀ
 ;   Note that the first string/ename sublist becomes the stub for the     
 ;   tentative ename sublist.  The string is retained as a marker so that  
 ;   new sublists of enames containing the same string can be identified   
 ;   and discarded.                                                        
 ; 
         (setq strlis (cdr strlis))              ; ditch from main list
         (setq tmplst strlis)                    ; copy of main list
 ; Ŀ
 ;   Find each occurrence of the string in the main list: get the string   
 ;   (car newsub) from the first sublist, use (assoc) to find the (string  
 ;   and ename) list in the duplicate main list, then use (member) to      
 ;   get the list and everything after it, (cdr) to remove the current     
 ;   duplicate sublist (which is then attached to Newsub, the tentative     
 ;   duplicate ename sublist).  Repeat this until (member) returns ().     
 ; 
         (while (and (setq enamtx (assoc (car newsub) tmplst))
                     (setq tmplst (member enamtx tmplst)))
                (setq newsub (append newsub (list (cadar tmplst))))
                (setq tmplst (cdr tmplst)))
 ; Ŀ
 ;   Add Newsub to Dupe if:                                                
 ;    1. Newsub has a length of > 1, that is if any duplicates of its      
 ;       string were found.                                                
 ;    2. The first atom in Newsub, the string, doesn't duplicate one in    
 ;       an existing sublist, since an ename can only be a member of one   
 ;       sublist.                                                          
 ; 
         (if (and (> (length newsub) 2)
                  (not (assoc (car newsub) dups)))
             (setq dups (append dups (list newsub)))))
 dups)
 ; Ŀ
 ;   Dupe end.                                                             
 ; 

 ; Ŀ
 ;   Duck                                                                  
 ; 
 (DEFUN C:DUCK (/ ss num len dups sub subma schlub)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get text strings to check.                                            
 ; 
  (setq ss (ssget (list (cons 0 "TEXT"))))
 ; Ŀ
 ;   Call Dupe to get a list of lists of text entities in the ss which     
 ;   have duplicate strings, in the format (("aa" enam enam ...) ...).     
 ; 
  (setq num 0)
  (setq len 0)
  (if (setq dups (dupe ss))
 ; Ŀ
 ;   If any duplicate were on top of each other then erase all but one.    
 ; 
      (while (setq sub (nth num dups))
             (setq num (1+ num))
 ; Ŀ
 ;   The first element in the list is the string, so ditch this.           
 ;   Check the position of each entity against each other one in each      
 ;   sublist and erase all but one at any given position.                  
 ;   Duplo makes a single list into a list of lists of entities with the   
 ;   same insertion point.  These already having been processed by Dupe    
 ;   to have the same string, so if a list contains >1 item then they      
 ;   must be identical in both respects.                                   
 ; 
             (if (> (length sub) 2)
                    (setq subma (duplo (cdr sub) 0.1))
                    (setq subma ()))
             (while (setq schlub (car subma))
                    (setq subma (cdr subma))
                    (while (> (length schlub) 1)
                           (setq enam (car schlub))
                           (setq pa (cdr (assoc 10 (entget enam))))
                           (entdel enam)
                           (setq len (1+ len))
                           (setq schlub (cdr schlub))
                           (crex pa)))))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (write-line (strcat "\n" (itoa len) " duplicate text entit"
                      (if (= len 1) "y" "ies") " erased."))
 (princ))